// Type15693.cpp : implementation file
//

#include "stdafx.h"
#include "rfidreader.h"
#include "Type15693.h"
#include "Share.h"
#include "RFID.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern SOCKET			g_hCOM;
extern CString			StrTmp;
extern unsigned char	Buffer[512];
extern unsigned char	DeviceAddr;
BOOL					g_isAutoInventory;
unsigned char			SndUID[32];
UINT ThreadProc(LPVOID ThreadParam);			

/////////////////////////////////////////////////////////////////////////////
// CType15693 dialog


CType15693::CType15693(CWnd* pParent /*=NULL*/)
	: CDialog(CType15693::IDD, pParent)
{
	//{{AFX_DATA_INIT(CType15693)
	m_strFlag = _T("22");
	m_strLockAFIFlag = _T("02");
	m_strLockAFIUID = _T("");
	m_strLockBlk = _T("05");
	m_strLockDSFIDFlag = _T("02");
	m_strLockDSFIDUID = _T("");
	m_strLockFlag = _T("02");
	m_strRdFlag = _T("02");
	m_strRdSecuFlag = _T("02");
	m_strRdSecunBlk = _T("05");
	m_strRdSecuStartBlk = _T("00");
	m_strRdSysFlag = _T("02");
	m_strRdSysSecuUID = _T("");
	m_strRdSysUID = _T("");
	m_strReadnBlk = _T("05");
	m_strReadStartBlk = _T("01");
	m_strReadUID = _T("");
	m_strRet15693MSG = _T("");
	m_strTransferData = _T("02 2B");
	m_strTransferLen = _T("02");
	m_strUID = _T("");
	m_strWrAFI = _T("06");
	m_strWrAFIFlag = _T("02");
	m_strWrAFIUID = _T("");
	m_strWrDSFID = _T("08");
	m_strWrDSFIDFlag = _T("02");
	m_strWrDSFIDUID = _T("");
	m_strWriteData = _T("11 11 11 11");
	m_strWriteFlag = _T("02");
	m_strWritenBlk = _T("01");
	m_strWriteStartBlk = _T("05");
	m_strWriteUID = _T("");
	//}}AFX_DATA_INIT
}


void CType15693::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CType15693)
	DDX_Control(pDX, IDC_BUTTONInvent, m_btnInvent);
	DDX_Control(pDX, IDC_BUTTONWriteDSFID, m_WriteDSFID);
	DDX_Control(pDX, IDC_BUTTONWriteBlk, m_btnWriteBlk);
	DDX_Control(pDX, IDC_BUTTONWriteAFI, m_btnWriteAFI);
	DDX_Control(pDX, IDC_BUTTONTranfer, m_btnTranfer);
	DDX_Control(pDX, IDC_BUTTONStayQuiet, m_btnStayQuiet);
	DDX_Control(pDX, IDC_BUTTONSelect, m_btnSelect);
	DDX_Control(pDX, IDC_BUTTONRSTtoReady, m_btnRSTtoReady);
	DDX_Control(pDX, IDC_BUTTONReadBlk, m_btnReadBlk);
	DDX_Control(pDX, IDC_BUTTONLockBlk, m_btnLockBlk);
	DDX_Control(pDX, IDC_BUTTONLockAFI, m_btnLockAFI);
	DDX_Control(pDX, IDC_BUTTONGetSysInfo, m_btnGetSysInfo);
	DDX_Control(pDX, IDC_BUTTONGetSecuInfo, m_btnGetSecuInfo);
	DDX_Control(pDX, IDC_BUTTONLockDSFID, m_btnLockDSFID);
	DDX_Control(pDX, IDC_BUTTONClear, m_btnClear);
	DDX_Text(pDX, IDC_EDITFlag, m_strFlag);
	DDV_MaxChars(pDX, m_strFlag, 2);
	DDX_Text(pDX, IDC_EDITLockAFIFlag, m_strLockAFIFlag);
	DDV_MaxChars(pDX, m_strLockAFIFlag, 2);
	DDX_Text(pDX, IDC_EDITLockAFIUID, m_strLockAFIUID);
	DDV_MaxChars(pDX, m_strLockAFIUID, 23);
	DDX_Text(pDX, IDC_EDITLockBlk, m_strLockBlk);
	DDV_MaxChars(pDX, m_strLockBlk, 2);
	DDX_Text(pDX, IDC_EDITLockDSFIDFlag, m_strLockDSFIDFlag);
	DDV_MaxChars(pDX, m_strLockDSFIDFlag, 2);
	DDX_Text(pDX, IDC_EDITLockDSFIDUID, m_strLockDSFIDUID);
	DDV_MaxChars(pDX, m_strLockDSFIDUID, 23);
	DDX_Text(pDX, IDC_EDITLockFlag, m_strLockFlag);
	DDV_MaxChars(pDX, m_strLockFlag, 2);
	DDX_Text(pDX, IDC_EDITRdFlag, m_strRdFlag);
	DDV_MaxChars(pDX, m_strRdFlag, 2);
	DDX_Text(pDX, IDC_EDITRdSecuFlag, m_strRdSecuFlag);
	DDV_MaxChars(pDX, m_strRdSecuFlag, 2);
	DDX_Text(pDX, IDC_EDITRdSecunBlk, m_strRdSecunBlk);
	DDV_MaxChars(pDX, m_strRdSecunBlk, 2);
	DDX_Text(pDX, IDC_EDITRdSecuStartBlk, m_strRdSecuStartBlk);
	DDV_MaxChars(pDX, m_strRdSecuStartBlk, 2);
	DDX_Text(pDX, IDC_EDITRdSysFlag, m_strRdSysFlag);
	DDV_MaxChars(pDX, m_strRdSysFlag, 2);
	DDX_Text(pDX, IDC_EDITRdSysSecuUID, m_strRdSysSecuUID);
	DDV_MaxChars(pDX, m_strRdSysSecuUID, 23);
	DDX_Text(pDX, IDC_EDITRdSysUID, m_strRdSysUID);
	DDV_MaxChars(pDX, m_strRdSysUID, 23);
	DDX_Text(pDX, IDC_EDITReadnBlk, m_strReadnBlk);
	DDV_MaxChars(pDX, m_strReadnBlk, 2);
	DDX_Text(pDX, IDC_EDITReadStartBlk, m_strReadStartBlk);
	DDV_MaxChars(pDX, m_strReadStartBlk, 2);
	DDX_Text(pDX, IDC_EDITReadUID, m_strReadUID);
	DDV_MaxChars(pDX, m_strReadUID, 23);
	DDX_Text(pDX, IDC_EDITRet15693MSG, m_strRet15693MSG);
	DDX_Text(pDX, IDC_EDITTransferData, m_strTransferData);
	DDX_Text(pDX, IDC_EDITTransferLen, m_strTransferLen);
	DDV_MaxChars(pDX, m_strTransferLen, 2);
	DDX_Text(pDX, IDC_EDITUID, m_strUID);
	DDV_MaxChars(pDX, m_strUID, 23);
	DDX_Text(pDX, IDC_EDITWrAFI, m_strWrAFI);
	DDV_MaxChars(pDX, m_strWrAFI, 2);
	DDX_Text(pDX, IDC_EDITWrAFIFlag, m_strWrAFIFlag);
	DDV_MaxChars(pDX, m_strWrAFIFlag, 2);
	DDX_Text(pDX, IDC_EDITWrAFIUID, m_strWrAFIUID);
	DDV_MaxChars(pDX, m_strWrAFIUID, 23);
	DDX_Text(pDX, IDC_EDITWrDSFID, m_strWrDSFID);
	DDV_MaxChars(pDX, m_strWrDSFID, 2);
	DDX_Text(pDX, IDC_EDITWrDSFIDFlag, m_strWrDSFIDFlag);
	DDV_MaxChars(pDX, m_strWrDSFIDFlag, 2);
	DDX_Text(pDX, IDC_EDITWrDSFIDUID, m_strWrDSFIDUID);
	DDV_MaxChars(pDX, m_strWrDSFIDUID, 23);
	DDX_Text(pDX, IDC_EDITWriteData, m_strWriteData);
	DDX_Text(pDX, IDC_EDITWriteFlag, m_strWriteFlag);
	DDV_MaxChars(pDX, m_strWriteFlag, 2);
	DDX_Text(pDX, IDC_EDITWritenBlk, m_strWritenBlk);
	DDV_MaxChars(pDX, m_strWritenBlk, 2);
	DDX_Text(pDX, IDC_EDITWriteStartBlk, m_strWriteStartBlk);
	DDV_MaxChars(pDX, m_strWriteStartBlk, 2);
	DDX_Text(pDX, IDC_EDITWriteUID, m_strWriteUID);
	DDV_MaxChars(pDX, m_strWriteUID, 23);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CType15693, CDialog)
	//{{AFX_MSG_MAP(CType15693)
	ON_EN_CHANGE(IDC_EDITRdFlag, OnChangeEDITRdFlag)
	ON_EN_CHANGE(IDC_EDITReadStartBlk, OnChangeEDITReadStartBlk)
	ON_EN_CHANGE(IDC_EDITReadnBlk, OnChangeEDITReadnBlk)
	ON_EN_CHANGE(IDC_EDITReadUID, OnChangeEDITReadUID)
	ON_EN_CHANGE(IDC_EDITWriteFlag, OnChangeEDITWriteFlag)
	ON_EN_CHANGE(IDC_EDITWriteStartBlk, OnChangeEDITWriteStartBlk)
	ON_EN_CHANGE(IDC_EDITWritenBlk, OnChangeEDITWritenBlk)
	ON_EN_CHANGE(IDC_EDITWriteUID, OnChangeEDITWriteUID)
	ON_EN_CHANGE(IDC_EDITWriteData, OnChangeEDITWriteData)
	ON_EN_CHANGE(IDC_EDITLockFlag, OnChangeEDITLockFlag)
	ON_EN_CHANGE(IDC_EDITLockBlk, OnChangeEDITLockBlk)
	ON_EN_CHANGE(IDC_EDITWrAFIFlag, OnChangeEDITWrAFIFlag)
	ON_EN_CHANGE(IDC_EDITWrAFIUID, OnChangeEDITWrAFIUID)
	ON_EN_CHANGE(IDC_EDITWrAFI, OnChangeEDITWrAFI)
	ON_EN_CHANGE(IDC_EDITLockAFIFlag, OnChangeEDITLockAFIFlag)
	ON_EN_CHANGE(IDC_EDITLockAFIUID, OnChangeEDITLockAFIUID)
	ON_EN_CHANGE(IDC_EDITWrDSFIDFlag, OnChangeEDITWrDSFIDFlag)
	ON_EN_CHANGE(IDC_EDITWrDSFIDUID, OnChangeEDITWrDSFIDUID)
	ON_EN_CHANGE(IDC_EDITWrDSFID, OnChangeEDITWrDSFID)
	ON_EN_CHANGE(IDC_EDITLockDSFIDFlag, OnChangeEDITLockDSFIDFlag)
	ON_EN_CHANGE(IDC_EDITLockDSFIDUID, OnChangeEDITLockDSFIDUID)
	ON_EN_CHANGE(IDC_EDITFlag, OnChangeEDITFlag)
	ON_EN_CHANGE(IDC_EDITUID, OnChangeEdituid)
	ON_EN_CHANGE(IDC_EDITRdSysFlag, OnChangeEDITRdSysFlag)
	ON_EN_CHANGE(IDC_EDITRdSysUID, OnChangeEDITRdSysUID)
	ON_EN_CHANGE(IDC_EDITRdSecuFlag, OnChangeEDITRdSecuFlag)
	ON_EN_CHANGE(IDC_EDITRdSecuStartBlk, OnChangeEDITRdSecuStartBlk)
	ON_EN_CHANGE(IDC_EDITRdSecunBlk, OnChangeEDITRdSecunBlk)
	ON_EN_CHANGE(IDC_EDITRdSysSecuUID, OnChangeEDITRdSysSecuUID)
	ON_EN_CHANGE(IDC_EDITTransferData, OnChangeEDITTransferData)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_CHECKInventory, OnCHECKInventory)
	ON_BN_CLICKED(IDC_BUTTONInvent, OnBUTTONInvent)
	ON_BN_CLICKED(IDC_BUTTONReadBlk, OnBUTTONReadBlk)
	ON_BN_CLICKED(IDC_BUTTONWriteBlk, OnBUTTONWriteBlk)
	ON_BN_CLICKED(IDC_BUTTONLockBlk, OnBUTTONLockBlk)
	ON_BN_CLICKED(IDC_BUTTONWriteAFI, OnBUTTONWriteAFI)
	ON_BN_CLICKED(IDC_BUTTONLockAFI, OnBUTTONLockAFI)
	ON_BN_CLICKED(IDC_BUTTONWriteDSFID, OnBUTTONWriteDSFID)
	ON_BN_CLICKED(IDC_BUTTONLockDSFID, OnBUTTONLockDSFID)
	ON_BN_CLICKED(IDC_BUTTONStayQuiet, OnBUTTONStayQuiet)
	ON_BN_CLICKED(IDC_BUTTONSelect, OnBUTTONSelect)
	ON_BN_CLICKED(IDC_BUTTONRSTtoReady, OnBUTTONRSTtoReady)
	ON_BN_CLICKED(IDC_BUTTONGetSysInfo, OnBUTTONGetSysInfo)
	ON_BN_CLICKED(IDC_BUTTONGetSecuInfo, OnBUTTONGetSecuInfo)
	ON_BN_CLICKED(IDC_BUTTONTranfer, OnBUTTONTranfer)
	ON_BN_CLICKED(IDC_BUTTONClear, OnBUTTONClear)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CType15693 message handlers

BOOL CType15693::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_btnInvent.SetThemeHelper(&m_ThemeHelper);
	m_WriteDSFID.SetThemeHelper(&m_ThemeHelper);
	m_btnWriteBlk.SetThemeHelper(&m_ThemeHelper);
	m_btnWriteAFI.SetThemeHelper(&m_ThemeHelper);
	m_btnTranfer.SetThemeHelper(&m_ThemeHelper);
	m_btnStayQuiet.SetThemeHelper(&m_ThemeHelper);
	m_btnSelect.SetThemeHelper(&m_ThemeHelper);
	m_btnRSTtoReady.SetThemeHelper(&m_ThemeHelper);
	m_btnReadBlk.SetThemeHelper(&m_ThemeHelper);
	m_btnLockBlk.SetThemeHelper(&m_ThemeHelper);
	m_btnLockAFI.SetThemeHelper(&m_ThemeHelper);
	m_btnGetSysInfo.SetThemeHelper(&m_ThemeHelper);
	m_btnGetSecuInfo.SetThemeHelper(&m_ThemeHelper);
	m_btnLockDSFID.SetThemeHelper(&m_ThemeHelper);
	m_btnClear.SetThemeHelper(&m_ThemeHelper);

	g_isAutoInventory = FALSE;
	SetTimer(1, 300, NULL);
	//m_pThread = AfxBeginThread(ThreadProc, this, THREAD_PRIORITY_NORMAL, 0, 0, NULL);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CType15693::OnChangeEDITRdFlag() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITRdFlag);
	m_strRdFlag = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CType15693::OnChangeEDITReadStartBlk() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITReadStartBlk);
	m_strReadStartBlk = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CType15693::OnChangeEDITReadnBlk() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITReadnBlk);
	m_strReadnBlk = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CType15693::OnChangeEDITReadUID() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITReadUID);
	m_strReadUID = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CType15693::OnChangeEDITWriteFlag() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITWriteFlag);
	m_strWriteFlag = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CType15693::OnChangeEDITWriteStartBlk() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITWriteStartBlk);
	m_strWriteStartBlk = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CType15693::OnChangeEDITWritenBlk() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITWritenBlk);
	m_strWritenBlk = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CType15693::OnChangeEDITWriteUID() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITWriteUID);
	m_strWriteUID = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);	
}

void CType15693::OnChangeEDITWriteData() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITWriteData);
	m_strWriteData = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CType15693::OnChangeEDITLockFlag() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITLockFlag);
	m_strLockFlag = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CType15693::OnChangeEDITLockBlk() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITLockBlk);
	m_strLockBlk = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CType15693::OnChangeEDITWrAFIFlag() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITWrAFIFlag);
	m_strWrAFIFlag = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CType15693::OnChangeEDITWrAFIUID() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITWrAFIUID);
	m_strWrAFIUID = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CType15693::OnChangeEDITWrAFI() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITWrAFI);
	m_strWrAFI = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CType15693::OnChangeEDITLockAFIFlag() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITLockAFIFlag);
	m_strLockAFIFlag = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CType15693::OnChangeEDITLockAFIUID() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITLockAFIUID);
	m_strLockAFIUID = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CType15693::OnChangeEDITWrDSFIDFlag() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITWrDSFIDFlag);
	m_strWrDSFIDFlag = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CType15693::OnChangeEDITWrDSFIDUID() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITWrDSFIDUID);
	m_strWrDSFIDUID = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CType15693::OnChangeEDITWrDSFID() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITWrDSFID);
	m_strWrDSFID = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CType15693::OnChangeEDITLockDSFIDFlag() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITLockDSFIDFlag);
	m_strLockDSFIDFlag = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CType15693::OnChangeEDITLockDSFIDUID() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITLockDSFIDUID);
	m_strLockDSFIDUID = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CType15693::OnChangeEDITFlag() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITFlag);
	m_strFlag = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CType15693::OnChangeEdituid() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITUID);
	m_strUID = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CType15693::OnChangeEDITRdSysFlag() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITRdSysFlag);
	m_strRdSysFlag = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CType15693::OnChangeEDITRdSysUID() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITRdSysUID);
	m_strRdSysUID = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CType15693::OnChangeEDITRdSecuFlag() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITRdSecuFlag);
	m_strRdSecuFlag = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CType15693::OnChangeEDITRdSecuStartBlk() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITRdSecuStartBlk);
	m_strRdSecuStartBlk	= CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
	
}

void CType15693::OnChangeEDITRdSecunBlk() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITRdSecunBlk);
	m_strRdSecunBlk = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CType15693::OnChangeEDITRdSysSecuUID() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here	
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITRdSysSecuUID);
	m_strRdSysSecuUID = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CType15693::OnChangeEDITTransferData() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITTransferData);
	m_strTransferData = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);

	CString	String;
	String.Format("%02X", strlen(m_strTransferData)/3 + ((strlen(m_strTransferData)%3) ? 1 : 0));
	SetDlgItemText(IDC_EDITTransferLen, String);
}

void CType15693::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	CXPStyleButtonST *AutoButton = (CXPStyleButtonST *) GetDlgItem(IDC_BUTTONInvent);
	if (g_isAutoInventory == TRUE) {
		 AutoButton->EnableWindow(FALSE);
         OnBUTTONInvent();
	}
	else {
		AutoButton->EnableWindow(TRUE);
	}
	CDialog::OnTimer(nIDEvent);
}

void CType15693::OnCHECKInventory()
{
	// TODO: Add your control notification handler code here
	g_isAutoInventory = ( ((CButton *)GetDlgItem(IDC_CHECKInventory))->GetCheck() & 1) ? TRUE : FALSE;
}

void CType15693::OnBUTTONInvent()
{
	// TODO: Add your control notification handler code here
	CString	String;

	UpdateData(true);
	if (INVALID_SOCKET == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device !", m_strRet15693MSG);
		UpdateData(false);
		return;
	}

	StrTmp.Format(">>Inventory\r\n");
	if ( (ret = API_ISO15693_Inventory(g_hCOM, DeviceAddr, 0x06, 0x00, 0x00, NULL, Buffer)) != 0) {
		String.Format("<<%s!", CShare::Return_CodeError(Buffer[0]));
		StrTmp += String;
	}
	else {
		for (int i = 1, k = 1; i <= Buffer[1]; i++, k += 10) {
			String.Format("<<UID%d:%02X %02X %02X %02X %02X %02X %02X %02X\r\n", i,
				Buffer[k+10], Buffer[k+9], Buffer[k+8], Buffer[k+7], Buffer[k+6], 
				Buffer[k+5], Buffer[k+4], Buffer[k+3]);
			StrTmp += String;
		}
		String.Format("%d %s be detected", Buffer[1], ((Buffer[1] > 1) ? "cards" : "card"));
		StrTmp += String;
	}
	
	CShare::WriteToResult(StrTmp, m_strRet15693MSG);
	UpdateData(false);
}

void CType15693::OnBUTTONReadBlk() 
{
	// TODO: Add your control notification handler code here
	unsigned char	Flag, StartBlock, nBlock;
	unsigned char	UID[32];
	CString			String;
	
	UpdateData(true);
	if (INVALID_SOCKET == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device !", m_strRet15693MSG);
		UpdateData(false);
		return;
	}
	
	Flag = (unsigned char) strtol(m_strRdFlag, NULL, 16);
	StartBlock = (unsigned char) strtol(m_strReadStartBlk, NULL, 16);
	nBlock = (unsigned char) strtol(m_strReadnBlk, NULL, 16);
	strcpy((char *)UID, m_strReadUID);
	int len = CShare::OXStrtoD(UID);
	int i, j;
	for (i = 0, j = len - 1; i < len; i++, j--)
		SndUID[j] = UID[i];

	StrTmp.Format(">>ReadBlock    Flags:%02X  StartAddr:%02X  Blocks:%02X\r\n", Flag, StartBlock, nBlock);
	if ( (ret = API_ISO15693_Read(g_hCOM, DeviceAddr, Flag, StartBlock, nBlock, SndUID, Buffer)) != 0) {
		String.Format("<<%s!", CShare::Return_CodeError(Buffer[0]));
		StrTmp += String;
	}
	else {
		String.Format("<<");
		StrTmp += String;
		for (int i = 2; i <= Buffer[0]; i++) {
			String.Format("%02X ", Buffer[i]);
			StrTmp += String;
		}
	}
	
	CShare::WriteToResult(StrTmp, m_strRet15693MSG);
	UpdateData(false);
}

void CType15693::OnBUTTONWriteBlk() 
{
	// TODO: Add your control notification handler code here
	unsigned char	Flag, StartBlock, nBlock;
	unsigned char	UID[32], WriteData[512];
	CString			String;
	
	UpdateData(true);
	if (INVALID_SOCKET == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device !", m_strRet15693MSG);
		UpdateData(false);
		return;
	}
	
	Flag = (unsigned char) strtol(m_strWriteFlag, NULL, 16);
	StartBlock = (unsigned char) strtol(m_strWriteStartBlk, NULL, 16);
	nBlock = (unsigned char) strtol(m_strWritenBlk, NULL, 16);
	strcpy((char *)UID, m_strWriteUID);
	int len = CShare::OXStrtoD(UID);
	strcpy((char *)WriteData, m_strWriteData);
	int datlen = CShare::OXStrtoD(WriteData);
	int i, j;
	for (i = 0, j = len - 1; i < len; i++, j--)
		SndUID[j] = UID[i];

	StrTmp.Format(">>WriteBlock    Flags:%02X  StartAddr:%02X  Blocks:%02X\r\n", Flag, StartBlock, nBlock);
	if (datlen != nBlock * 4) {
		String.Format("<<%s!", CShare::Return_CodeError(0x85));
		StrTmp += String;
		CShare::WriteToResult(StrTmp, m_strRet15693MSG);
		UpdateData(false);
		return;
	}

	if ( (ret = API_ISO15693_Write(g_hCOM, DeviceAddr, Flag, StartBlock, nBlock, SndUID, WriteData)) != 0) {
		String.Format("<<%s!", CShare::Return_CodeError(WriteData[0]));
		StrTmp += String;
	}
	else {
		String.Format("<<Writing Success !");
		StrTmp += String;
	}
	
	CShare::WriteToResult(StrTmp, m_strRet15693MSG);
	UpdateData(false);
}

void CType15693::OnBUTTONLockBlk() 
{
	// TODO: Add your control notification handler code here
	unsigned char	Flag, BlockAddr;
	unsigned char	UID[8];
	CString			String;
	
	UpdateData(true);
	if (INVALID_SOCKET == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device !", m_strRet15693MSG);
		UpdateData(false);
		return;
	}
	
	Flag = (unsigned char) strtol(m_strLockFlag, NULL, 16);
	BlockAddr = (unsigned char) strtol(m_strLockBlk, NULL, 16);
	if (MessageBox("Rewriting will be not available if the block locked !", "Attention", MB_OKCANCEL | MB_ICONINFORMATION) != 1)
		return;

	StrTmp.Format(">>LockBlock    Flags:%02X  Block:%02X\r\n", Flag, BlockAddr);
	if ( (ret = API_ISO15693_Lock(g_hCOM, DeviceAddr, Flag, BlockAddr, UID, Buffer)) != 0) {
		String.Format("<<%s!", CShare::Return_CodeError(Buffer[0]));
		StrTmp += String;
	}
	else {
		//if (Buffer[0] == 0x80)
		String.Format("<<Locking Success !");
		StrTmp += String;
	}
	
	CShare::WriteToResult(StrTmp, m_strRet15693MSG);
	UpdateData(false);
}

void CType15693::OnBUTTONWriteAFI() 
{
	// TODO: Add your control notification handler code here
	unsigned char	Flag, AFI;
	unsigned char	UID[32];
	CString			String;
	
	UpdateData(true);
	if (INVALID_SOCKET == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device !", m_strRet15693MSG);
		UpdateData(false);
		return;
	}
	
	Flag = (unsigned char) strtol(m_strWrAFIFlag, NULL, 16);
	AFI = (unsigned char) strtol(m_strWrAFI, NULL, 16);
	strcpy((char *) UID, m_strWrAFIUID);
	int len = CShare::OXStrtoD(UID);
	int i, j;
	for (i = 0, j = len - 1; i < len; i++, j--)
		SndUID[j] = UID[i];

	StrTmp.Format(">>WriteAFI    Flags:%02X  AFI:%02X\r\n", Flag, AFI);
	if ( (ret = API_ISO15693_WriteAFI(g_hCOM, DeviceAddr, Flag, AFI, SndUID, Buffer)) != 0) {
		String.Format("<<%s!", CShare::Return_CodeError(Buffer[0]));
		StrTmp += String;
	}
	else {
		//if (Buffer[0] == 0x80)
		String.Format("<<WriteAFI Success !");
		StrTmp += String;
	}
	
	CShare::WriteToResult(StrTmp, m_strRet15693MSG);
	UpdateData(false);
}

void CType15693::OnBUTTONLockAFI() 
{
	// TODO: Add your control notification handler code here
	unsigned char	Flag;
	unsigned char	UID[32];
	CString			String;
	
	UpdateData(true);
	if (INVALID_SOCKET == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device !", m_strRet15693MSG);
		UpdateData(false);
		return;
	}
	
	Flag = (unsigned char) strtol(m_strLockAFIFlag, NULL, 16);
	strcpy((char *) UID, m_strLockAFIUID);
	int len = CShare::OXStrtoD(UID);
	int i, j;
	for (i = 0, j = len - 1; i < len; i++, j--)
		SndUID[j] = UID[i];

	StrTmp.Format(">>LockAFI    Flags:%02X\r\n", Flag);
	if ( (ret = API_ISO15693_LockAFI(g_hCOM, DeviceAddr, Flag, SndUID, Buffer)) != 0) {
		String.Format("<<%s!", CShare::Return_CodeError(Buffer[0]));
		StrTmp += String;
	}
	else {
		//if (Buffer[0] == 0x80)
		String.Format("<<LockAFI Success !");
		StrTmp += String;
	}
	
	CShare::WriteToResult(StrTmp, m_strRet15693MSG);
	UpdateData(false);
}

void CType15693::OnBUTTONWriteDSFID() 
{
	// TODO: Add your control notification handler code here
	unsigned char	Flag, DSFID;
	unsigned char	UID[32];
	CString			String;
	
	UpdateData(true);
	if (INVALID_SOCKET == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device !", m_strRet15693MSG);
		UpdateData(false);
		return;
	}
	
	Flag = (unsigned char) strtol(m_strWrDSFIDFlag, NULL, 16);
	DSFID = (unsigned char) strtol(m_strWrDSFID, NULL, 16);
	strcpy((char *) UID, m_strWrDSFIDUID);
	int len = CShare::OXStrtoD(UID);
	int i, j;
	for (i = 0, j = len - 1; i < len; i++, j--)
		SndUID[j] = UID[i];

	StrTmp.Format(">>WriteDSFID    Flags:%02X  DSFID:%02X\r\n", Flag, DSFID);
	if ( (ret = API_ISO15693_WriteDSFID(g_hCOM, DeviceAddr, Flag, DSFID, SndUID, Buffer)) != 0) {
		String.Format("<<%s!", CShare::Return_CodeError(Buffer[0]));
		StrTmp += String;
	}
	else {
		//if (Buffer[0] == 0x80)
		String.Format("<<WriteDSFID Success !");
		StrTmp += String;
	}
	
	CShare::WriteToResult(StrTmp, m_strRet15693MSG);
	UpdateData(false);
}

void CType15693::OnBUTTONLockDSFID() 
{
	// TODO: Add your control notification handler code here
	unsigned char	Flag;
	unsigned char	UID[32];
	CString			String;
	
	UpdateData(true);
	if (INVALID_SOCKET == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device !", m_strRet15693MSG);
		UpdateData(false);
		return;
	}
	
	Flag = (unsigned char) strtol(m_strLockAFIFlag, NULL, 16);
	strcpy((char *) UID, m_strLockDSFIDUID);
	int len = CShare::OXStrtoD(UID);
	int i, j;
	for (i = 0, j = len - 1; i < len; i++, j--)
		SndUID[j] = UID[i];

	StrTmp.Format(">>LockDSFID    Flags:%02X\r\n", Flag);
	if ( (ret = API_ISO15693_LockDSFID(g_hCOM, DeviceAddr, Flag, SndUID, Buffer)) != 0) {
		String.Format("<<%s!", CShare::Return_CodeError(Buffer[0]));
		StrTmp += String;
	}
	else {
		//if (Buffer[0] == 0x80)
		String.Format("<<LockDSFID Success!");
		StrTmp += String;
	}
	
	CShare::WriteToResult(StrTmp, m_strRet15693MSG);
	UpdateData(false);
}

void CType15693::OnBUTTONStayQuiet() 
{
	// TODO: Add your control notification handler code here
	unsigned char	Flag;
	unsigned char	UID[32];
	CString			String;
	
	UpdateData(true);
	if (INVALID_SOCKET == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device !", m_strRet15693MSG);
		UpdateData(false);
		return;
	}
	
	Flag = (unsigned char) strtol(m_strFlag, NULL, 16);
	strcpy((char *) UID, m_strUID);
	int len = CShare::OXStrtoD(UID);
	int i, j;
	for (i = 0, j = len - 1; i < len; i++, j--)
		SndUID[j] = UID[i];

	StrTmp.Format(">>StayQuiet    Flags:%02X\r\n", Flag);
	if ( (ret = API_ISO15693_StayQuiet(g_hCOM, DeviceAddr, Flag, SndUID, Buffer)) != 0) {
		String.Format("<<%s!", CShare::Return_CodeError(Buffer[0]));
		StrTmp += String;
	}
	else {
		//if (Buffer[0] == 0x80)
		String.Format("<<StayQuiet Success!");
		StrTmp += String;
	}
	
	CShare::WriteToResult(StrTmp, m_strRet15693MSG);
	UpdateData(false);
}

void CType15693::OnBUTTONSelect() 
{
	// TODO: Add your control notification handler code here
	unsigned char	Flag;
	unsigned char	UID[32];
	CString			String;
	
	UpdateData(true);
	if (INVALID_SOCKET == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device !", m_strRet15693MSG);
		UpdateData(false);
		return;
	}
	
	Flag = (unsigned char) strtol(m_strFlag, NULL, 16);
	strcpy((char *) UID, m_strUID);
	int len = CShare::OXStrtoD(UID);
	int i, j;
	for (i = 0, j = len - 1; i < len; i++, j--)
		SndUID[j] = UID[i];

	StrTmp.Format(">>Select     Flags:%02X\r\n", Flag);
	if ( (ret = API_ISO15693_Select(g_hCOM, DeviceAddr, Flag, SndUID, Buffer)) != 0) {
		String.Format("<<%s!", CShare::Return_CodeError(Buffer[0]));
		StrTmp += String;
	}
	else {
		//if (Buffer[0] == 0x80)
		String.Format("<<Select Success!");
		StrTmp += String;
	}
	
	CShare::WriteToResult(StrTmp, m_strRet15693MSG);
	UpdateData(false);	
}

void CType15693::OnBUTTONRSTtoReady() 
{
	// TODO: Add your control notification handler code here
	unsigned char	Flag;
	unsigned char	UID[32];
	CString			String;
	
	UpdateData(true);
	if (INVALID_SOCKET == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device !", m_strRet15693MSG);
		UpdateData(false);
		return;
	}
	
	Flag = (unsigned char) strtol(m_strFlag, NULL, 16);
	strcpy((char *) UID, m_strUID);
	int len = CShare::OXStrtoD(UID);
	int i, j;
	for (i = 0, j = len - 1; i < len; i++, j--)
		SndUID[j] = UID[i];

	StrTmp.Format(">>ResetToReady    Flags:%02X\r\n", Flag);
	if ( (ret = API_ISO15693_ResetToReady(g_hCOM, DeviceAddr, Flag, SndUID, Buffer)) != 0) {
		String.Format("<<%s!", CShare::Return_CodeError(Buffer[0]));
		StrTmp += String;
	}
	else {
		//if (Buffer[0] == 0x80)
		String.Format("<<RSTtoReady Success!");
		StrTmp += String;
	}
	
	CShare::WriteToResult(StrTmp, m_strRet15693MSG);
	UpdateData(false);
}

void CType15693::OnBUTTONGetSysInfo() 
{
	// TODO: Add your control notification handler code here
	unsigned char	Flag;
	unsigned char	UID[32];
	CString			String;
	
	UpdateData(true);
	if (INVALID_SOCKET == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device !", m_strRet15693MSG);
		UpdateData(false);
		return;
	}
	
	Flag = (unsigned char) strtol(m_strRdSysFlag, NULL, 16);
	strcpy((char *) UID, m_strRdSysUID);
	int len = CShare::OXStrtoD(UID);
	int i, j;
	for (i = 0, j = len - 1; i < len; i++, j--)
		SndUID[j] = UID[i];

	StrTmp.Format(">>Get system info    Flags:%02X\r\n", Flag);
	if ( (ret = API_ISO15693_GetSysInfo(g_hCOM, DeviceAddr, Flag, SndUID, Buffer)) != 0) {
		String.Format("<<%s!", CShare::Return_CodeError(Buffer[0]));
		StrTmp += String;
	}
	else {
		String.Format("<<");
		StrTmp += String;
		for (int i = 2; i <= Buffer[0]; i++) {
			String.Format("%02X ", Buffer[i]);
			StrTmp += String;
		}
	}
	
	CShare::WriteToResult(StrTmp, m_strRet15693MSG);
	UpdateData(false);
}

void CType15693::OnBUTTONGetSecuInfo() 
{
	// TODO: Add your control notification handler code here
	unsigned char	Flag, StartBlock, nBlock;
	unsigned char	UID[32];
	CString			String;
	
	UpdateData(true);
	if (INVALID_SOCKET == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device !", m_strRet15693MSG);
		UpdateData(false);
		return;
	}
	
	Flag = (unsigned char) strtol(m_strRdSecuFlag, NULL, 16);
	StartBlock = (unsigned char) strtol(m_strRdSecuStartBlk, NULL, 16);
	nBlock = (unsigned char) strtol(m_strRdSecunBlk, NULL, 16);
	strcpy((char *) UID, m_strRdSysSecuUID);
	int len = CShare::OXStrtoD(UID);
	int i, j;
	for (i = 0, j = len - 1; i < len; i++, j--)
		SndUID[j] = UID[i];

	StrTmp.Format(">>Get system secure info    Flags:%02X  StartAddr:%02X  Blocks:%02X\r\n", Flag, StartBlock, nBlock);
	if ( (ret = API_ISO15693_GetMulSecurity(g_hCOM, DeviceAddr, Flag, StartBlock, nBlock, SndUID, Buffer)) != 0) {
		String.Format("<<%s!", CShare::Api_Error(ret), CShare::Return_CodeError(Buffer[0]));
		StrTmp += String;
	}
	else {
		String.Format("<<");
		StrTmp += String;
		for (int i = 2; i <= Buffer[0]; i++) {
			String.Format("%02X ", Buffer[i]);
			StrTmp += String;
		}
	}
	
	CShare::WriteToResult(StrTmp, m_strRet15693MSG);
	UpdateData(false);
}

void CType15693::OnBUTTONTranfer() 
{
	// TODO: Add your control notification handler code here
	unsigned char	SendData[1024];
	int				DataLen;
	CString			String;
	
	UpdateData(true);
	if (INVALID_SOCKET == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device !", m_strRet15693MSG);
		UpdateData(false);
		return;
	}
	
	DataLen = strtol(m_strTransferLen, NULL, 16);
	strcpy((char *) SendData, m_strTransferData);
	int SizeStr = CShare::OXStrtoD(SendData);

	if (SizeStr != DataLen) {
		MessageBox("Invalid format of the input parameters!", "Warning", MB_OK | MB_ICONINFORMATION);
		return;
	}

	StrTmp.Format(">>Transmit    Length:%d  Data:%s\r\n", DataLen, m_strTransferData);
	if ( (ret = API_ISO15693_TransCmd(g_hCOM, DeviceAddr, DataLen, SendData, Buffer)) != 0) {
		String.Format("<<%s!", CShare::Return_CodeError(Buffer[0]));
		StrTmp += String;
	}
	else {
		String.Format("<<");
		StrTmp += String;
		for (int i = 1; i <= Buffer[0]; i++) {
			String.Format("%02X ", Buffer[i]);
			StrTmp += String;
		}
	}
	
	CShare::WriteToResult(StrTmp, m_strRet15693MSG);
	UpdateData(false);
}

void CType15693::OnBUTTONClear() 
{
	// TODO: Add your control notification handler code here
	UpdateData(true);
	m_strRet15693MSG = "";
	UpdateData(false);
}

UINT ThreadProc(LPVOID ThreadParam)
{
	CType15693 *pDlg = (CType15693 *)ThreadParam;
	CXPStyleButtonST *AutoButton = ((CXPStyleButtonST *) pDlg->GetDlgItem(IDC_BUTTONInvent));

	do {
		if (g_isAutoInventory == TRUE) {
			AutoButton->EnableWindow(FALSE);
			AutoButton->SendMessage(WM_LBUTTONDOWN);
			AutoButton->SendMessage(WM_LBUTTONUP);
		}
		else {
			AutoButton->EnableWindow(TRUE);
		}
		Sleep(300);
	} while (1);
	
	return 0;
}
